/**
* \file: device_handler.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef device_handler_h
#define device_handler_h

#include "control/watch.h"
#include "model/device.h"
#include "model/partition.h"

typedef struct
{    
	error_code_t (*init)(void);

	error_code_t (*blacklist_mounted_device)(const char* mount_src);

	void (*deinit)(void);

	const char *device_handler_id;

} devicehandler_vtable_t;

extern const devicehandler_vtable_t *device_handler_list[];

error_code_t device_handler_init_all(void);

error_code_t device_handler_add_event_source(watch_t *watch, uint32_t event_mask);

error_code_t device_handler_remove_event_source(watch_t *watch);

error_code_t device_handler_blacklist_mounted_device_all(const char* mount_src);

void device_handler_deinit_all(void);

#endif
